﻿using UnityEngine;
using System.Collections;


public enum STATE
{
   PREMENU,
   MENU,
   SELECTLVL,
   LOADING_IN_PROGRESS,
   PLAY,
   OPTION,
   LEAVE,
   SCORE,
   GAMEOVER,

   COUNT
}



public class StateMachine : MonoBehaviour {

    public static StateMachine instance;
    private STATE state;

    public Process[] stateGameObjectList;
    

    // Use this for initialization----------------------------------------------------
    void Start ()
    {
        if(instance!=null)
        {
            Debug.LogError("Singleton cannot instanciate twice");
            return;
        }

        instance = this;

        state = STATE.PREMENU;

        for (STATE s = STATE.PREMENU; s < STATE.COUNT; s++)
        {
            stateGameObjectList[(int)s].gameObject.SetActive(s == state);
        }
    }
	

    //------------------------------------------------------------------------------------

    public void SetState(STATE newState)
    {
        //on desactive l'ancien
        stateGameObjectList[(int)state].gameObject.SetActive(false);


        //on active le nouveau
        stateGameObjectList[(int) newState].gameObject.SetActive(true);
        stateGameObjectList[(int)newState].Init();

        state = newState;

    }

}
